#version 150
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Square DanceMod01.fsh by   mla
//https://www.shadertoy.com/view/tlBcRW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
// Variant on https://www.shadertoy.com/view/WlByRW by @FabriceNeyret2
// mla, 2020
////////////////////////////////////////////////////////////////////////////////

float square(vec2 z, float r) {
  float d = max(abs(z.x),abs(z.y));
  return 1.0-smoothstep(0.0,0.1,abs(d-r));
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 z = (2.0*fragCoord - iResolution.xy)/iResolution.y;
  float scale = 8.0;
  z *= scale;
  float tt = iTime;
  z += 0.5*z*mat2(cos(0.25*z+tt),sin(0.25*z-tt));
  
  // If f(z) is our function, then f(z+dz) = f(z)+J*dz
  // ie. J approximates f locally as a linear function.
  mat2 J = mat2(dFdx(z),dFdy(z))*iResolution.y/(2.0*scale);

  // Fold in to [-1,1]
  z /= 2.0;
  vec2 index = round(z);
  z -= round(z);
  z *= 2.0;
  vec2 z1 = z;

  // Apply inverse coordinate transform
  z = inverse(J)*z;

  vec3 col = vec3(0);
  // red channel shows distances (from the cell centre) in transformed coordinates
  col.r = (0.5+0.5*sin(length(20.0*z1)))*0.6;
  // blue shows distances in the inverse transformed coordinates
  col.b = (0.5+0.5*sin(length(20.0*z)))*0.6;
  col.g = abs(1.0-pow(abs(determinant(J)),0.5));

  // A square in inverse coordinates, so (approximately) screen aligned
  // and the same size.
  //float t = fract(0.5*iTime);
  // Phased and random square by Fabrice, thanks.
  //float t = fract(0.5*iTime+0.1*(index.x+10.0*index.y));
  float t = fract(0.5*iTime+sin(dot(index,iResolution.xy)));
  col = mix(col,vec3(1),0.75*square(z,t));

  // Transformed cell boundaries
  z1 = abs(z1);
  if (z1.y > z1.x) z1 = z1.yx;
  col *= 0.25+0.75*smoothstep(0.0,0.2,1.0-z1.x);

  // Inverse transformed cell axes.
  z = abs(z);
  if (z.y > z.x) z = z.yx;
  col *= 0.25+0.75*smoothstep(0.0,0.1,z.y);
  col = pow(col,vec3(0.4545));
  //outcolor = fragColor;
  fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); // set the pixel to the value of vec4 cc 
}

